#!/usr/bin/perl -w 
# program to read the ampcal stats files for individual experiments and form a
# database 
# Cormac Reynolds:  Nov 2004 - original program.

# first add the perlmod directory to @INC
BEGIN{
  $perlmod = $0;
  $perlmod =~ s/\/[^\/]*?$//;
  unless ($perlmod =~ /\//) {
    $perlmod = '.';
  }
  $perlmod .= '/perlmod';
  unshift @INC, $perlmod ;
}
use Getopt::Std;
#use PGPLOT;
use crfuncs;
use strict;
use POSIX;
use Date::Manip qw(ParseDate UnixDate Date_DayOfYear Date_DaysInYear);
#use vars qw($opt_o);

usage();

#getopts ('o');

# get the name of the input file
#chomp ($infile=$ARGV[0]) if (defined $ARGV[0]);
unless (@ARGV) {
  print "Enter the input file name(s) (^D to finish):\n";
  chomp (@ARGV = <STDIN>);
  #die "Cannot find input file: $infile";
}


my ($outfile) = 'ampcal.dat';
open (OUTFILE, ">>$outfile");

# first read in MASTER_PROJECTS.LIS to get the dates of all the experiments
my ($masterfile) = "/home/michael/vlbi/ampcal/MASTER_PROJECTS.LIS"; 
open (MASTEREXP, "$masterfile") || die "can\'t open file $masterfile: $!\n";
my (%ampcal);
MASTER: while (<MASTEREXP>) {
  s/^\s+//;
  s/#.*//;
  if (/\w/) {
    my (@master) = split (/\s+/, $_) ;
    foreach my $master (@master) {;
      $master = lc $master
    }
    #print "@master\n";
    $master[1] = transdate ($master[1]);
    $ampcal{$master[0]}{'date'} = $master[1];
  }
}
close (MASTEREXP);

foreach my $infile (@ARGV) {
  open (INFILE, "$infile") || die "can\'t open file $infile: $!\n";
  print "processing $infile\n";
  my ($expname) = $infile;
  $expname =~ s/^.*\///;
  unless ($expname =~ /_/) {
    #$expname =~ s/\.ampcal/_all_all_all.ampcal/;
    $expname =~ s/\.ampcal/_all.ampcal/;
  }
  $expname =~ s/_.*$//;
  # the following regexp properly takes care of multi-pass experiments, but
  # need to add some logic to recognise matches with MASTEREXP.LIS which
  # doesn't know about passes...
  #$expname =~ s/_[^_]*_[^_]*_[^_]*$//;

  #my ($source) = $infile;
  #$source =~ s/^.*\///;
  #unless ($source =~ /_/) {
  #  $source =~ s/\.ampcal/_all.ampcal/;
  #}
  #$source =~ s/.*_//;
  #$source =~ s/\.ampcal//;

  my ($source) = ();
  my ($freqstart) = 0;
  my ($tel) = ();
  #read in the files 
  READFILE: while (<INFILE>) {
    chomp;
    s/^\s+//;
    # remove comments
    s/#.*$//;

    if (/^FILE =/i) {
      $source = (split)[2];
      #print "source = $source\n";
    }

    if (/FQID/) {$freqstart = 1; next READFILE}

    if ($freqstart) {
      my ($freqline) = $_;
      $ampcal{$expname}{'source'}{$source}{'freq'} = (split (/\s+/, $freqline))[2];
      $freqstart = 0;
    }

    if (/Station=\d+\((\w+)\)/i) {
      $tel = $1;
      #print "$details\n";
      #$ampcal{$expname}{$source}{'tel'} = $tel;
      #print "here: $ampcal{$expname}{$source}{'tel'}\n" ;
      next READFILE ;
    }

    if (/All:/i) {
      my ($ifstats) = $_;
      my (@ifstats) = split (/\s+/, $ifstats) ;
      #print "$expname, $source, $tel\n";
      #print "%{$ampcal{$expname}{$source}}\n";
# Lindqvist
      $ampcal{$expname}{'source'}{$source}{'tel'}{$tel}{'ampifall'} = $ifstats;
    }
  }
  close (INFILE);
}



foreach my $expname (sort keys %ampcal) {
  #print "expname = $expname\n";
  foreach my $source (sort keys %{$ampcal{$expname}{'source'}}) {
    #print "source = $source\n";
    foreach my $tel (sort keys %{$ampcal{$expname}{'source'}{$source}{'tel'}}) {
      #print "tel = $tel\n";
      my ($amperr) = $ampcal{$expname}{'source'}{$source}{'tel'}{$tel}{'ampifall'};
      #$amperr = (1+$amperr)**2 - 1;
      #$amperr = sprintf ("%2.4f", $amperr);
      print OUTFILE "$expname $ampcal{$expname}{'date'} $source $tel $ampcal{$expname}{'source'}{$source}{'freq'}  $amperr\n";
    }
  }
}

##########################
sub usage {
  print <<EOF
usage: ampcaldb.pl [options] <filename>
options: none yet
EOF
      ;

}

##########################
sub transdate {
  my ($indate) = $_[0];

  my ($year) = substr($indate, 0, 4);
  my ($month) = substr($indate, 4, 2);
  my ($day) = substr($indate, 6, 2);

  my ($dayofyear) = Date_DayOfYear($month,$day,$year);
  my ($totdays) = Date_DaysInYear($year);

  my ($outdate) = $year + $dayofyear/$totdays;
  $outdate = sprintf ("%4.3f", $outdate);
  return $outdate;
}
