#!/usr/bin/perl -w 
# program to read data and do some stats
# Cormac Reynolds:  Aug 2001 - original program.
#                   Feb 2003 - added bunch of command-line options, and moved
#                       main plotting part to a subroutine in plot.pm 
#                   Aug 2003 - made several command-line options vectors, so
#                       different files can have different attributes.

# first add the perlmod directory to @INC
BEGIN{
  $perlmod = $0;
  $perlmod =~ s/\/[^\/]*?$//;
  unless ($perlmod =~ /\//) {
    $perlmod = '.';
  }
  $perlmod .= '/perlmod';
  unshift @INC, $perlmod ;
}
use Getopt::Long;
use PGPLOT;
use crfuncs;
use strict;
use POSIX;
my ($infile,$i,@data,@x,@y,$temp,$xmin,$xmax,$ymin,$ymax,$deltax,$deltay);
my (@xx,$nfiles,$j,$symb,$file,$xind);
my ($xl,$xh,$yl,$yh,$xlab,$ylab,$title,$ndata,$colour);

usage();

# parse the options. 
my $xcol = ();
my @xcol = ();
my $skiprow = ();
my @skiprow = ();
my $string = ();

GetOptions ('x=s'=>\$xcol, 'skip=s'=>\$skiprow, 'grep=s'=>\$string) ;
            
            

unless (defined $xcol) {$xcol=1}
unless (defined $skiprow) {$skiprow=0}

# choose the x columns to plot
if (defined $xcol) {
  $xcol =~ s/^\s+//;
  $xcol =~ s/,/ /g;
  @xcol = split (/\s+/, $xcol);
}


# arrasy to record which first rows of the file should be skipped at the start
if (defined $skiprow) {
  $skiprow =~ s/^\s+//;
  $skiprow =~ s/,/ /g;
  @skiprow = split (/\s+/, $skiprow);
}


# get the name of the input file
#chomp ($infile=$ARGV[0]) if (defined $ARGV[0]);
unless (@ARGV) {
  print "Enter the input file name(s) (^D to finish):\n";
  chomp (@ARGV = <STDIN>);
  #die "Cannot find input file: $infile";
}

$nfiles=0;
$xcol = ();
$skiprow = ();
foreach $infile (@ARGV) {
  unless ($infile =~ /\w/) {next}
  open (INFILE,"$infile") || die "can\'t open file $infile: $!\n";
  print "$infile\n";


  if ($xcol[$nfiles]) {
    $xcol = $xcol[$nfiles];
  }else {
    $xcol = $xcol[0];
  }

  if ($skiprow[$nfiles]) {
    $skiprow = $skiprow[$nfiles];
  }else {
    $skiprow = $skiprow[0];
  }

  #read in the data
  READFILE: while (<INFILE>) {
    chomp;
    s/^\s+//;
    unless (/\w/) {next READFILE}
    unless ($. > $skiprow) {next READFILE}
    if (defined $string) {
      unless (/$string/) {next READFILE}
    }

    @data = split (/\s+/);


    push (@xx, $data[$xcol-1]);
  }
  ++$nfiles;
  close (INFILE);
}




#print "@y\n";
#$temp = scalar(@x);
#print "xdata=$temp\n";
#$temp = scalar(@y);
#print "ydata=$temp\n";


my (@temp) = ();
@temp = stats (@xx);
# and write out the results
if (@temp) {

  print 'The number of data points is: ', ${$temp[0]}, " \n";;
  print "The sum of data points is: ${$temp[1]}\n" ;
  print "The stdev in the sample (sig(n)) is: ${$temp[2]}\n" ;
  print "The stdev in the population (sig(n-1)) is: ${$temp[3]}\n";
  print "The mean is: ${$temp[4]}\n";
  print "The median is: ${$temp[5]}\n";
  print "The standard error on the mean is: ${$temp[6]}\n";
  print "The maximum of the data is: ${$temp[7]}\n";
  print "The minimum of the data is: ${$temp[8]}\n";

}

print "\n";


##########################
sub usage {
  print <<EOF
usage: plot.pl [options] <filename>
Calculates stats for data from a file in column format.
options: -x=<n>         selects data from column <n>. If analysing multiple
                        files can give list of <n> - one for each file.
         -skip=<n>      Skip the first <n> lines of the file. If analysing
                        multiple files can give list of <n>
         -grep=<text>   Only process lines containing the string <text> 
                        (strictly <text> is a perl regexp)
EOF
      ;

}
