#
# This awk script fits mean delay and rate for data for each day, 
# estimates rms scatter about this mean taking out the effect of 
# the rate within each day, converts day number of year to MJD and finally 
# formats output for sending to astbo1. 
#
# Changed  2000-05-10 OSO FC.
# 	MJD for year and GPS label must now be supplied on command line
#	eg. 'YearMJD=51543.0 GPSlabel=GPSOSO1' for year 2000 and GPSOSO1
#
# usage: awk -f awk.oneday.com jun96.1000s.ed2 YearMJD=51543.0 GPSlabel=GPSOSO1 > GPS.ON
# 
# First pass through, load array
#
BEGIN { }
#
{ ncount=ncount+1; time=$1;
  {if (ncount==1) 
    {modulo1=$1%1; day=$1-modulo1; oldday=day; startday=day}
#
# AGP 3-5-1999
# Had to add variable modulo1, new version of awk did not like
# day=$1-($1%1) Don't know why
#
#    print day,oldday,startday}
  else
    {oldday = day; modulo2=$1%1
    day= $1-modulo2    } }; 
  if (oldday!=day) 
    {numday[oldday]=num; num=1;
    tarray[day,num] = time;
    array[day,num] = $2}
#
# AGP 3-5-1999
# As above had to introduce variable modulo2 because direct day=$1-($1%1)
# did not seem to work with new version of AWK
# 
#    print "ifold",oldday}
  else 
    {num=num+1; 
    tarray[day,num] = time;
    array[day,num] = $2;
    oldtwo = $2}
#   print ncount, oldday, time, day, num, numday[day], array[day,num]
    }
#
END {numday[day]=num;
    tarray[day,num] = time;
    array[day,num] = oldtwo;
    endday=day;
#
#   Print out contents of array
# 
#      for (i=startday; i<= endday; i++) 
#         { for (j=1; j<=numday[i]; j++) 
#           {print i,j, array[i,j]
#           }                
#           };  
#
#   Find mean delay and time for each day
#      
      for (i=startday; i<= endday; i++) 
         { if (numday[i]>2) { for (j=1; j<=numday[i]; j++) 
           {sum1 = sum1 + (array[i,j]);
            sum2 = sum2 + (tarray[i,j]); 
#          print i,j, array[i,j], sum1, sum2
           };  mean[i] = sum1/numday[i]; 
               tmean[i] = sum2/numday[i]; 
           sum1=0; sum2=0
           }}; 
#
#   Find mean rate for each day
#
       for (i=startday; i<= endday; i++) 
          { if (numday[i]>2) {for (j=1; j<=numday[i]; j++) 
        { numer = numer  + (tarray[i,j] - tmean[i])*(array[i,j]-mean[i]);
      denom = denom  + ((tarray[i,j] -tmean[i])*(tarray[i,j] - tmean[i]))
           }; 
           rmean[i] = (numer/denom); 
           numer = 0; denom = 0 
           }}
#
#   Estimate rms after taking out mean rate for that day
#
       for (i=startday; i<= endday; i++) 
          { if (numday[i]>2) {for (j=1; j<=numday[i]; j++) 
        { diff = array[i,j]-(mean[i]+((tarray[i,j]-tmean[i])*rmean[i])); 
          sum = sum + (diff*diff) }; 
           rms[i] = sqrt( sum/numday[i]);
#          print i, numday[i], tmean[i], mean[i], rms[i], rmean[i];
            sum = 0
           }}
#
#   Print out correctly formatted data, note standard format is 
#   GPS-formatter, so must flip sign
#
#   NOTE: 20/01/1997 : To confront with the GPS standard we take out the
#         sign reversal (AGP/JEC) 
     print "# MJD      offset  rms GPSname"
     for (i=startday; i<= endday; i++) {if (numday[i]>2) 
      { printf "%9.3f %6.3f %5.3f %s \n", YearMJD+tmean[i],
#        (-mean[i]/1000.0), (rms[i]/1000.0) }    
        (mean[i]/1000.0), (rms[i]/1000.0), GPSlabel} 
     }}

  










