#!/bin/sh
#
# Script to copy time_yyyy_ddd.log file into
# ./monthYY subdir, filter bad values, 
# make 1000s average and oneday value using awk scripts
#
# should be run daily using cron ./day.sh '1 days ago'
#
# 2000-02-17  OSO Fredrik.C Antonis.P KarlAke.J
# 2000-05-09  Changed to use year in log file name
# 2000-05-10  Changed to supply year MJD to 'awk.oneday.com' script generated by 'mjd.sh'
#

# Where the original GPS log files resides
maserdatdir='/home/maser/maser/log/'
file='time_'
ext='.log'

# Where processed gps data subdirs goes
homedir='.'

# Label to be written to oneday log 
GPSlabel="GPSOSO1"

if [ $# -lt 1 ]
	then
		echo "Error no datestring specified"
		echo "Usage:"
		echo "	$0 datestr"
		exit 0 	
	else
		# Check if date string is valid
		if ! date -d "$*" 1>/dev/null
		then
			exit;
		fi
		year=`date -d "$*" +%y`
		Year=`date -d "$*" +%Y`
		dayofmonth=`date -d "$*" +%d`
		dayno=`date -d "$*" +%j`
		mondir=`date -d "$*" +%b%y`
    fi    

# Set up files
sourceGPSfile="$maserdatdir$file$Year"_"$dayno$ext"
filtredGPSfile="$homedir/$mondir/$file$dayno$ext"
tmp1000sfile="$homedir/$mondir/$file$dayno"".1000s"
month1000sfile="$homedir/$mondir/$mondir"".1000s"
onedayfile="$homedir/$mondir/$mondir"".oneday"



# Make month dir if there is none
if [ ! -d "$mondir" ]
   then
	mkdir $mondir
	echo $mondir
fi

# Filter for bad values and copy specified day's log file to correct month dir if it exists
# and if is not already in month dir
    if [ -f $sourceGPSfile ] ; then
    	if [ ! -f $filtredGPSfile ]; then
	grep -v [E,e] $sourceGPSfile | cat > $filtredGPSfile
	else
	echo "Error: file already exists $filtredGPSfile"
	echo "Script allready executed for this day?"
	exit 0
	fi
    else
	echo "Error: cant find $sourceGPSfile"
    	exit 0
    fi
    

# Make 1000s average
if ! awk -f awk.1000s.com $filtredGPSfile > $tmp1000sfile
   then
	echo "Error making 1000s average"
	exit 0
   fi


# Check if oneday file exists if so append to it without header 
if [ ! -f $onedayfile ]
   then
   
   # Make one day average file with header
   if ! awk -f awk.oneday.com $tmp1000sfile YearMJD=`sh mjd.sh 0 Jan $Year` GPSlabel=$GPSlabel > $onedayfile
   	then
		echo "Error making one day file"
		exit 0
   fi
   else
   # Append to one day average file skip header
   if ! awk -f awk.oneday.com $tmp1000sfile YearMJD=`sh mjd.sh 0 Jan $Year` GPSlabel=$GPSlabel | tail -1 >> $onedayfile
   	then
		echo "Error appending one day file"
		exit 0
   fi
   
fi


# Append temporary day 1000s ave file to month 1000s file and then del day 1000s
if ! cat $tmp1000sfile >> $month1000sfile
   then
	exit 1;
fi

rm -r $tmp1000sfile

echo "Dayno "$dayno" processed OK!"
exit 1
