#!/bin/sh
#
# Script to FTP specified date's './month/month.oneday' file to
# remote server, using ftpput.sh script.
# 
# should be run daily using cron ./ftplog.sh `date -d "today"`
# 2000-05-10 OSO FC.

homedir='.'
ext='.oneday'
SERVER='vlbeer.ira.bo.cnr.it'
# Fill in login and passw for the ftp server.
LOGIN='evn'
PASSW='nest_sexion'

# Your stations remote gps data file name.
RFILE='gps.on'


if [ $# -lt 1 ]
	then
		echo "Error no datestring specified"
		echo "Usage:"
		echo "	$0 datestr"
		exit 0 	
	else
		# Check if date string is valid
		if ! date -d "$*" 1>/dev/null
		then
			exit 0;
		fi
		year=`date -d "$*" +%y`
		dayofmonth=`date -d "$*" +%d`
		dayno=`date -d "$*" +%j`
		mondir=`date -d "$*" +%b%y`
    fi    

RPATH='gps/'
# Add lowercase month subdir to remote path.
RPATH=$RPATH`echo $mondir|tr '[:upper:]' '[:lower:]'`
LPATH="$homedir/$mondir/"
LFILE="$mondir$ext"

# FTP the file
    if [ -f $LPATH$LFILE ] ; then
	if ./ftpput.sh $SERVER $LOGIN $PASSW $RPATH $LPATH $LFILE $RFILE
		then
			echo "$0: Error: could not ftp file $LPATH$LFILE"
			echo "Check the login and password"
			exit 0;
	fi
    else
       echo "Error: cant find $LPATH$LFILE"
    exit 0
    fi
exit 1
