#!/bin/sh
# FtpPut: transfers oneday file and renames it to 'gps.on' to FTP server
# Parameters: Server login passw RPath LPath LFile [RFile]
# 2000-04-12 OSO F.C

FTPFILE="$HOME/.netrc"

if [ $# -lt 6 -o $# -gt 7 ]
	then
		echo "$0: Error wrong number of arguments"
		echo "Usage:"
		echo "	$0 Server login passw RPath LPath LFilename [RFilename]"
		echo ""
		echo "Caution!! $0 deletes the .netrc file in the users home directory."
		echo ""
		exit 0 	
	else
		SERVER=$1
		LOGIN=$2
		PASSW=$3
		RPATH=$4
		LPATH=$5
		LFILE="$6"
		if [ $# -lt 7 ]
		then
			RFILE=$LFILE
		else
			RFILE="$7"
		fi
    fi    

echo Server : $SERVER
echo RDir    : $RPATH
echo LDir    : $LPATH
echo "LFile   : $LFILE"
echo "RFile   : $RFILE"
echo Jobfile: $FTPFILE
echo

touch $FTPFILE
chmod 600 $FTPFILE

echo machine $SERVER >$FTPFILE
echo login $LOGIN >>$FTPFILE
echo password $PASSW >>$FTPFILE
echo macdef init >>$FTPFILE
echo  lcd $LPATH >>$FTPFILE
echo  cd $RPATH >>$FTPFILE
echo  bin >>$FTPFILE
echo  put $LFILE $RFILE >>$FTPFILE
echo  close >>$FTPFILE
echo  quit >>$FTPFILE
echo>>$FTPFILE

ftp -i $SERVER

rm -f $FTPFILE

exit 1
