#!/bin/sh
#
# Modified Julian Date script
# generates MJD for supplied date using bc calculator.
# 2000-05-10 OSO Fredrik.C
#
# usage: ./mjd 'datestr'
#

if [ $# -lt 1 ]
        then
                echo "Julian date script"
                echo "Error no datestring specified"
                echo "Usage:"
                echo "  $0 datestr"
                exit 0
        else
		# Check if date string is valid
		if ! date -d "$*" 1>/dev/null
		then
			exit 0
		fi
                year=`date -d "$*" +%Y`
                day=`date -d "$*" +%d`
                dayno=`date -d "$*" +%j`
                month=`date -d "$*" +%m`
    fi

# This bc script calculates Modified Julian Day
bcscript=\
"year=$year;month=$month;day=$day;
if (month<3) {if (month==2||month==1) {month+=12;year-=1;}}
scale = 0;
a = year/100; b1 = a/4; b = 2 - a + a/4;
mjd = (((365.25*(year+4716))/1) + ((30.6001 * (month+1))/1) + day + b -1524.5) -2400000.5;
mjd;
quit;";

MJD=`echo "$bcscript"| bc -l -q`

echo $MJD
exit 1 
