#!/bin/sh
#
# Script to process a month of data 
# using the day.sh script
# 2000-02-17 OSO Fredrik.C
#

if [ $# -lt 1 ]
	then
		echo "Error no monthdatestring specified"
		echo "Usage:"
		echo "	$0 month year"
		echo "eg. $0 Jan 2000"
		exit 0 	
	else
		# Check if date string is valid
		if ! date -d "1 $*" 1>/dev/null
		then
			exit;
		fi
		year=`date -d "1 $1 $2" +%y`
		dayofmonth=`date -d "1 $1 $2" +%d`
		dayno=`date -d "1 $1 $2" +%j`
		month=`date -d "1 $1 $2" +%m`
    fi    

datestr=`date -d "$year-$month-01"`
i=0;
processed=0; 
while [ $month -eq `date -d "$datestr" +%m` ]
do
	if ! ./day.sh $datestr
	then
		processed=`expr $processed + 1`
	fi
	i=`expr $i + 1`
	datestr=`date -d "$i days 1 $*"`
done

if [ $i -ne $processed ]
then
	echo Processed $processed files out of $i in month $*
else 
	echo "Month "$*" done OK!"
fi
exit 1
