#!/bin/sh
#
# Script to copy time_yyyy_ddd.log file into
# ./monthYY subdir, filter bad values, 
# make 1000s average and daily values using awk scripts
#
# should be run daily using cron ./day.sh '1 days ago'
#
# 2000-02-17  OSO Antonis.P Fredrik.C Karlake.J
# 2000-05-09  Changed to use year in log file name
# 2000-05-10  Changed to supply year MJD to 'awk.oneday.com' script generated by 'mjd.sh'
#

# Where the orginal 'time_yyyy_ddd.log' files recides
maserdatdir='/home/maser/maser/log/'
file='time_'
ext='.log'

# Where processed gps data files recide
homedir='.'

# Name of data 
GPSlabel="GPSOSO1"

if [ $# -lt 1 ]
	then
		echo "Error no datestring specified"
		echo "Usage:"
		echo "	$0 datestr"
		exit 0 	
	else
		# Check if date string is valid
		if ! date -d "$*" 1>/dev/null
		then
			exit;
		fi
		year=`date -d "$*" +%y`
		Year=`date -d "$*" +%Y`
		dayofmonth=`date -d "$*" +%d`
		dayno=`date -d "$*" +%j`
		mondir=`date -d "$*" +%b%y`
    fi    

# Make month dir if there is none
if [ ! -d "$mondir" ]
   then
	mkdir $mondir
	echo $mondir
fi

# Filter for bad values and copy day log file to correct month dir if it exists
# and if is not already in month dir
    if [ -f "$maserdatdir$file$Year"_"$dayno$ext" ] ; then
    	if [ ! -f "$homedir/$mondir/$file$dayno$ext" ]; then
	grep -v [E,e] "$maserdatdir$file$Year"_"$dayno$ext"| cat > "$homedir/$mondir/$file$dayno$ext"
	else
	echo "Error: file already exists $homedir/$mondir/$file$dayno$ext"
	echo "Script allready executed for this day?"
	exit 0
	fi
    else
	echo "Error: cant find $maserdatdir$file$Year"_"$dayno$ext"
    	exit 0
    fi
    

# Make 1000s average
if ! awk -f awk.1000s.com "$homedir/$mondir/$file$dayno$ext" > "$homedir/$mondir/$file$dayno"".1000s"
   then
	echo "Error making 1000s average"
	exit 0
   fi


# check if oneday file exists if so append to it without header 
if [ ! -f "$homedir/$mondir/$mondir"".oneday" ]
   then
   
   # Make One day average
   if ! awk -f awk.oneday.com "$homedir/$mondir/$file$dayno"".1000s" YearMJD=`sh mjd.sh 0 Jan $Year` GPSlabel=$GPSlabel > "$homedir/$mondir/$mondir"".oneday"
   	then
		echo "Error making one day file"
		exit 0
   fi
   else
   if ! awk -f awk.oneday.com "$homedir/$mondir/$file$dayno"".1000s" YearMJD=`sh mjd.sh 0 Jan $Year` GPSlabel=$GPSlabel | tail -1 >> "$homedir/$mondir/$mondir"".oneday"
   	then
		echo "Error appending one day file"
		exit 0
   fi
   
fi


# Append day 1000s ave file to mon 1000s file and then del day 1000s
if ! cat "$homedir/$mondir/$file$dayno"".1000s" >> "$homedir/$mondir/$mondir"".1000s"
   then
	exit 1;
fi

rm -r "$homedir/$mondir/$file$dayno"".1000s"

echo "Dayno "$dayno" processed OK!"
exit 1
